function f_out=audio_filt(f_in,Fs)
%
% This function simply does a band-pass filter to rewrite
% the data as a 300 - 3000 Hz signal.
% Note - I couldn't get a satisfactory response using firpm
% to design a band-pass filter directly!
%

%% Filtering
%Fs=11025*2;
% High-pass filter: 300 Hz cut-off
hhp=firpm(200,[0 100*2/Fs 300*2/Fs  1],[0 0 1 1 ],[1 10 ]);
% Low-pass filter: cutt-off 3000 Hz
hlp=firpm(200,[0 3000*2/Fs 3500*2/Fs  1],[1 1 0 0 ],[10 1 ]);

f_out= fftfilt(hlp,fftfilt(hhp,f_in));

%% See the filter 
% figure
% freqz(hhp,1,100,Fs),hold on,freqz(hlp,1,100,Fs)
% legend('High Pass','Low Pass')
% title('Audio Filter (Post-Decoding or Pre-Encoding)')
% hold on
% set(gcf,'color','w')
% legend('Low Pass: Fs=11.025 KHz','High Pass: Fs=11.025 KHz','Low Pass: Fs=22.05 KHz','High Pass: Fs=22.05 KHz')
